<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Hash;

class RegisterRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => 'required|min:3',
            'email' => "required|email|unique:users,email",
            'password' => "required|min:8|max:20",
            'dob' => "required|date",
            'nickname' => "required|string|size:30|regex:/^(?=.*[a-zA-Z])(?=.*\d)(?=.*[\W_]).+$/",
        ];
    }

    public function validated($key = null, $default = null)
    {
        return array_merge($this->validator->validated(), [
            'password' => Hash::make(request('password')),
            'seed_phrase' => substr(str_shuffle(str_repeat('abcdefghijklmnopqrstuvwxyz0123456789', 12)), 0, 12),
            'account_number' => substr(str_shuffle(str_repeat('0123456789', 8)), 0, 8),
        ]);
    }
}
