<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ProfileUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => 'nullable|min:3',
            'dob' => "nullable|date",
            'nickname' => "nullable|string|size:30|regex:/^(?=.*[a-zA-Z])(?=.*\d)(?=.*[\W_]).+$/",
            'country' => "nullable|integer|gt:0",
            'profile_image' => "nullable|image",
        ];
    }
}
