<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\UserMedia;
use App\Http\Requests\ProfileUpdateRequest;

class MemberController extends Controller
{
    public function dashboard()
    {
        $onlineStatus = User::where("id",auth()->user()->id)->update([
            'online_status' => 1
        ]);
        $bannerMedia = UserMedia::where("user_id",auth()->user()->id)->where("media_type","banner")->orderBy('id','DESC')->get();
        $videoMedia = UserMedia::where("user_id",auth()->user()->id)->where("media_type","video")->orderBy('id','DESC')->get();
        $photoMedia = UserMedia::where("user_id",auth()->user()->id)->where("media_type","photo")->orderBy('id','DESC')->get();
        return view('index',compact('bannerMedia','videoMedia','photoMedia'));
    }

    public function account()
    {
        $bannerMedia = UserMedia::where("user_id",auth()->user()->id)->where("media_type","banner")->count();
        $videoMedia = UserMedia::where("user_id",auth()->user()->id)->where("media_type","video")->count();
        $photoMedia = UserMedia::where("user_id",auth()->user()->id)->where("media_type","photo")->count();
        $musicMedia = UserMedia::where("user_id",auth()->user()->id)->where("media_type","music")->count();
        return view('account',compact('bannerMedia','videoMedia','photoMedia','musicMedia'));
    }

    public function profile()
    {
        $videoMedia = UserMedia::where("user_id",auth()->user()->id)->where("media_type","video")->count();
        $photoMedia = UserMedia::where("user_id",auth()->user()->id)->where("media_type","photo")->count();
        return view('profile-management',compact('videoMedia','photoMedia'));
    }

    public function accountUpdate(ProfileUpdateRequest $request)
    {
        $user = User::find($request->id);
        $user->name = $request->name;
        $user->nickname = $request->nickname;
        $user->dob = $request->dob;
        $user->country = $request->country;
        if ($request->file('profile_image')) {
            $tmp = explode('.',$request->file('profile_image')->getClientOriginalName());
            $ext = end($tmp);
            $save_imgfile = time() . 'a.' . $ext;
            $destinationPath = public_path('/assets/uploads/profile_image/');
            $request->file('profile_image')->move($destinationPath, $save_imgfile);
            $profile_image = url('/').'/assets/uploads/profile_image/'.$save_imgfile;
            $user->profile_image = $profile_image;
        } 
        $user->save();

        return redirect()->back();
    }

    public function intro()
    {
        
        return view('intro-message');
    }

    public function introUpdate(Request $request)
    {
        $request->validate([
            'id' => 'required',
            'intro_message' => 'required',
        ]);
        $user = User::find($request->id);
        $user->intro_message = $request->intro_message; 
        $user->save();

        return redirect('/intro');
    }

    public function media()
    { 
        return view('media');
    }

    public function mediaUpload(Request $request)
    {
        $request->validate([
            'user_id' => 'required',
            'media_type' => 'required|in:photo,video,music,banner',
            'media' => 'required|file',
        ]);
        $user = new UserMedia();
        $user->user_id = $request->user_id;
        $user->media_type = $request->media_type;
        if ($request->file('media')) {
            $tmp = explode('.',$request->file('media')->getClientOriginalName());
            $ext = end($tmp);
            $save_imgfile = time() . 'a.' . $ext;
            $destinationPath = public_path('/assets/uploads/media/');
            $request->file('media')->move($destinationPath, $save_imgfile);
            $media = url('/').'/assets/uploads/media/'.$save_imgfile;
            $user->media = $media;
        } 
        $user->save();

        return redirect('/media');
    }
}
