<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\RegisterRequest;
use App\Models\User;
use Illuminate\Http\Request;

class RegisterController extends Controller
{
    public function store(RegisterRequest $request)
    {
        $user = User::create([
            'name' => $request->name,
            'nickname' => $request->nickname,
            'dob'=> $request->dob,
            'email'=> $request->email,
            'password' => $request->password,
            'seed_phrase' => $request->seed_phrase,
            'account_number' => $request->account_number,
        ]);

        auth()->login($user);

        return redirect("/dashboard");
    }
}
