<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\LoginRequest;
use Illuminate\Http\Request;

class LoginController extends Controller
{
    public function store(LoginRequest $request)
    {
        if (auth()->attempt($request->validated())) {
            return redirect()->route('dashboard');
        }

        return redirect()->back()->withErrors([
            'email' => "Invalid email",
            'password' => "Invalid password",
        ]);
    }
}
